<?php
 
include_once 'conexao.php';

class ModeloUsuario
{
        
	static public function mdlAddUsuario($dados){
 
		$stmt = Conexao::conectar()->prepare("INSERT INTO usuario (nome,senha,tipoDeConta,idLogin,imagem,idEmpresa,email) VALUES 
																(:nomeCompleto,:senha,:nivel,:id,:imagem,:idEmpresa,:email)");

		$stmt->bindParam(":nomeCompleto", $dados["nomeCompleto"], PDO::PARAM_STR);
		$stmt->bindParam(":senha", $dados["senha"], PDO::PARAM_STR);
		$stmt->bindParam(":nivel", $dados["categoria"], PDO::PARAM_STR);
		$stmt->bindParam(":id", $dados["telefone"], PDO::PARAM_STR);
		$stmt->bindParam(":imagem", $dados["imagem"], PDO::PARAM_STR);
		$stmt->bindParam(":idEmpresa", $dados["idEmpresa"], PDO::PARAM_STR);
		$stmt->bindParam(":email", $dados["email"], PDO::PARAM_STR);

		if($stmt->execute()){

			return "ok"; 

		}else{

			return "error";
		
		}

	}
 
	static public function mdlAddUsuarioRapido($dados){
 
		$stmt = Conexao::conectar()->prepare("INSERT INTO usuario (nome,senha,tipoDeConta,idLogin,imagem,idEmpresa,email,saldoConta,pais) VALUES 
																(:nomeCompleto,:senha,:nivel,:id,:imagem,:idEmpresa,:email,:saldoConta,:pais)");
		$saldoConta = 0;
		$stmt->bindParam(":nomeCompleto", $dados["nomeCompleto"], PDO::PARAM_STR);
		$stmt->bindParam(":senha", $dados["senha"], PDO::PARAM_STR);
		$stmt->bindParam(":nivel", $dados["categoria"], PDO::PARAM_STR);
		$stmt->bindParam(":pais", $dados["pais"], PDO::PARAM_STR);
		$stmt->bindParam(":id", $dados["telefone"], PDO::PARAM_STR);
		$stmt->bindParam(":imagem", $dados["imagem"], PDO::PARAM_STR);
		$stmt->bindParam(":idEmpresa", $dados["idEmpresa"], PDO::PARAM_STR);
		$stmt->bindParam(":email", $dados["email"], PDO::PARAM_STR);
		$stmt->bindParam(":saldoConta", $saldoConta, PDO::PARAM_STR);

		if($stmt->execute()){
			return "ok";
		}else{
			return "error";
		}

	}

	static public function mdlAddUsuarioEmpresa($dados){
 
		$stmt = Conexao::conectar()->prepare("INSERT INTO usuario (nome,senha,tipoDeConta,idLogin,imagem,idEmpresa,email,saldoConta,bi_nif,localizacao,pais,estadoDaConta) VALUES 
																(:nomeCompleto,:senha,:nivel,:id,:imagem,:idEmpresa,:email,:saldoConta,:nif,:localizacao,:pais,:estadoDaConta)");
		$saldoConta = 0;
		$stmt->bindParam(":nomeCompleto", $dados["nomeCompleto"], PDO::PARAM_STR);
		$stmt->bindParam(":senha", $dados["senha"], PDO::PARAM_STR);
		$stmt->bindParam(":nivel", $dados["categoria"], PDO::PARAM_STR);
		$stmt->bindParam(":id", $dados["telefone"], PDO::PARAM_STR);
		$stmt->bindParam(":imagem", $dados["imagem"], PDO::PARAM_STR);
		$stmt->bindParam(":idEmpresa", $dados["bi_nif"], PDO::PARAM_STR);
		$stmt->bindParam(":email", $dados["email"], PDO::PARAM_STR);
		$stmt->bindParam(":nif", $dados["bi_nif"], PDO::PARAM_STR);
		$stmt->bindParam(":localizacao", $dados["localizacao"], PDO::PARAM_STR);
		$stmt->bindParam(":pais", $dados["pais"], PDO::PARAM_STR);
		$stmt->bindParam(":estadoDaConta", $dados["estadoDaConta"], PDO::PARAM_STR);
		$stmt->bindParam(":saldoConta", $saldoConta, PDO::PARAM_STR);

		if($stmt->execute()){
			return "ok";
		}else{
			return "error";
		}

	}

	static public function mdlVerificarSeUsuarioJaExiste($bi){

		$resultado = array();

		$stmt = Conexao::conectar()->prepare("SELECT * FROM usuario where bi_nif = :bi");
		$stmt->bindParam(":bi", $bi, PDO::PARAM_STR);
		$stmt ->execute();

		$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;

	}

	static public function mdlMostrarUsuarioPorTipoConta($tipoConta){

		$resultado = array();

		$stmt = Conexao::conectar()->prepare("SELECT * FROM usuario where tipoDeConta = :tipoConta");
		$stmt->bindParam(":tipoConta", $tipoConta, PDO::PARAM_STR);
		$stmt ->execute();

		$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;

	}

	static public function mdlMostrarUsuarioPorNomeETipoConta($nome,$tipoConta){

		$resultado = array();

		$stmt = Conexao::conectar()->prepare("SELECT * FROM usuario where nome = :nome and tipoDeConta = :tipoConta");
		$stmt->bindParam(":tipoConta", $tipoConta, PDO::PARAM_STR);
		$stmt->bindParam(":nome", $nome, PDO::PARAM_STR);
		$stmt ->execute();

		$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;

	}

	static public function mdlMostrarUsuarioPorSexoETipoConta($sexo,$tipoConta){

		$resultado = array();

		$stmt = Conexao::conectar()->prepare("SELECT * FROM usuario where sexo = :sexo and tipoDeConta = :tipoConta");
		$stmt->bindParam(":tipoConta", $tipoConta, PDO::PARAM_STR);
		$stmt->bindParam(":sexo", $sexo, PDO::PARAM_STR);
		$stmt ->execute();

		$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;

	}

	static public function mdlMostrarUsuarioPorEmailETipoConta($email,$tipoConta){

		$resultado = array();

		$stmt = Conexao::conectar()->prepare("SELECT * FROM usuario where email = :email and tipoDeConta = :tipoConta");
		$stmt->bindParam(":tipoConta", $tipoConta, PDO::PARAM_STR);
		$stmt->bindParam(":email", $email, PDO::PARAM_STR);
		$stmt ->execute();

		$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;

	}

	static public function mdlMostrarUsuarioPorPaisETipoConta($pais,$tipoConta){

		$resultado = array();

		$stmt = Conexao::conectar()->prepare("SELECT * FROM usuario where pais = :pais and tipoDeConta = :tipoConta");
		$stmt->bindParam(":tipoConta", $tipoConta, PDO::PARAM_STR);
		$stmt->bindParam(":pais", $pais, PDO::PARAM_STR);
		$stmt ->execute();

		$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;

	}
 
	static public function mdlMostrarTodosUsuarioPorBIeTelefone($bi, $telefone){

		$resultado = array();

		$stmt = Conexao::conectar()->prepare("SELECT * FROM usuario where bi_nif = :bi and idLogin = :telefone");
		$stmt->bindParam(":bi", $bi, PDO::PARAM_STR);
		$stmt->bindParam(":telefone", $telefone, PDO::PARAM_STR);
		$stmt->execute();

		$resultado = $stmt->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;

	}

	static public function mdlVerificarSeUsuarioJaExistePeloTelefone($telefone){

		$resultado = array();
		$stmt = Conexao::conectar()->prepare("SELECT * FROM usuario where idLogin = :telefone");
		$stmt->bindParam(":telefone", $telefone, PDO::PARAM_STR); 
		$stmt ->execute();
		$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;
	} 
 
	static public function mdlMostrarTodosUsuario(){

		$resultado = array();

			$stmt = Conexao::conectar()->prepare("SELECT * FROM usuario");
			$stmt ->execute();
			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	} 
	 
	static public function mdlMostrarDadosDoUsuarioPorID($idUsuario){

		$resultado = array();

		$stmt = Conexao::conectar()->prepare("SELECT * FROM usuario where idUsuario = :idUsuario");
		$stmt->bindParam(":idUsuario", $idUsuario, PDO::PARAM_STR);
		$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	} 
 
	static public function mdlMostrarTodosUsuarioComLimite($limite){

		$resultado = array(); 

			$stmt = Conexao::conectar()->query("SELECT * FROM usuario order by idUsuario desc limit $limite");
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	} 

	static public function mdlActualizarDadosUsuarioprofessors($nome, $bi_nif, $nivelDeAcesso,$id){ 
			
		$stmt = Conexao::conectar()->query("UPDATE usuario SET nome = '$nome', bi_nif = '$bi_nif', tipoDeConta = '$nivelDeAcesso' where  idUsuario = '$id'");
			#$stmt ->execute();
			return true;
			
	}
	
	static public function mdlActualizarDadosUsuarioOrganizacao($nome, $bi_nif, $email, $localizacao, $descricao, $id){ 
			
		$stmt = Conexao::conectar()->query("UPDATE usuario SET nome = '$nome', bi_nif = '$bi_nif', email = '$email',  localizacao = '$localizacao', descricao = '$descricao' where  idUsuario = '$id'");
		return true;
			
	}

	static public function mdlActualizarCodigoParaReporSenha($idUsuario, $codigo){
			
		$stmt = Conexao::conectar()->query("UPDATE usuario SET codigoParaReporSenha = '$codigo' where idUsuario = '$idUsuario'");
		#$stmt ->execute();
		return true;
		
	} 

	static public function mdlActualizarDadosBancariosDoUsuario($idUsuario, $nomeDoBanco, $iban, $numContaBacaria, $nomeProprietarioConta){
			
		$stmt = Conexao::conectar()->query("UPDATE usuario SET nomeDoBanco = '$nomeDoBanco', iban = '$iban', numContaBacaria = '$numContaBacaria', nomeProprietarioConta = '$nomeProprietarioConta' where idUsuario = '$idUsuario'");
		#$stmt ->execute();
		return $stmt;
		
	} 

	static public function mdlActualizarSaldoUsuario($saldo,$id){
			
		$stmt = Conexao::conectar()->query("UPDATE usuario SET saldoConta = '$saldo' where idUsuario = '$id'");
		#$stmt ->execute();
		return true;
		
}

	static public function mdlActualizarImagemPerfilUsuario($imagem,$id){
		$stmt = Conexao::conectar()->query("UPDATE usuario SET imagem = '$imagem' where  idUsuario = '$id'");
		#$stmt ->execute();
		return true;
	}

	static public function mdlActualizarReporSenhaUsuario($senha,$id,$codigoParaReporSenha){

		$stmt = Conexao::conectar()->query("UPDATE usuario SET senha = '$senha' where  idUsuario = '$id' and codigoParaReporSenha = '$codigoParaReporSenha'");
		#$stmt ->execute();
		return true;

	}

	static public function mdlDeletarUsuario($id){
		
		$Dados = Conexao::conectar()->prepare("DELETE from usuario where  idUsuario = :t ");
		$Dados->bindValue(":t",$id);
		if($Dados ->execute())
		{
			return true;
		}else{
			return false;
		}
		
			
	}
  
	static public function mdlActualizarDadosUsuario($nome, $bi_nif, $sexo, $email,$pais,$localizacao ,$id,$senha){

		$Dados = Conexao::conectar()->prepare("SELECT * from usuario where idUsuario = :t and senha = :s");
		$Dados->bindValue(":t",$id);
		$Dados->bindValue(":s",$senha);
		$Dados ->execute();
		if ($Dados ->rowCount() > 0) {
			$stmt = Conexao::conectar()->query("UPDATE usuario SET nome = '$nome', bi_nif = '$bi_nif', sexo = '$sexo', email = '$email', pais = '$pais', localizacao = '$localizacao' where  idUsuario = '$id'");
			#$stmt ->execute();
			return true;
			}
			else{
				return false;
			}
	} 
	static public function mdlActualizarSenhaUsuario($senhaAntiga,$id,$senhaNova){

			$Dados = Conexao::conectar()->prepare("SELECT * from usuario where idUsuario = :t and senha = :s");
			$Dados->bindValue(":t",$id);
			$Dados->bindValue(":s",$senhaAntiga);
			$Dados ->execute();
			if ($Dados ->rowCount() > 0) {
				$resultado = $Dados ->fetch();
				$stmt = Conexao::conectar()->query("UPDATE usuario SET senha = '$senhaNova' where  idUsuario = '$id'");
				#$stmt ->execute();
				return true;
			}
			else{
				return false;
			}
		}

}



  ?>